<?php
/**
 *
 * The framework's functions and definitions
 */
define( 'WOODMART_THEME_DIR', get_template_directory_uri() );
define( 'WOODMART_THEMEROOT', get_template_directory() );
define( 'WOODMART_IMAGES', WOODMART_THEME_DIR . '/images' );
define( 'WOODMART_SCRIPTS', WOODMART_THEME_DIR . '/js' );
define( 'WOODMART_STYLES', WOODMART_THEME_DIR . '/css' );
define( 'WOODMART_FRAMEWORK', '/inc' );
define( 'WOODMART_DUMMY', WOODMART_THEME_DIR . '/inc/dummy-content' );
define( 'WOODMART_CLASSES', WOODMART_THEMEROOT . '/inc/classes' );
define( 'WOODMART_CONFIGS', WOODMART_THEMEROOT . '/inc/configs' );
define( 'WOODMART_HEADER_BUILDER', WOODMART_THEME_DIR . '/inc/header-builder' );
define( 'WOODMART_ASSETS', WOODMART_THEME_DIR . '/inc/admin/assets' );
define( 'WOODMART_ASSETS_IMAGES', WOODMART_ASSETS . '/images' );
define( 'WOODMART_API_URL', 'https://xtemos.com/wp-json/xts/v1/' );
define( 'WOODMART_DEMO_URL', 'https://woodmart.xtemos.com/' );
define( 'WOODMART_PLUGINS_URL', WOODMART_DEMO_URL . 'plugins/' );
define( 'WOODMART_DUMMY_URL', WOODMART_DEMO_URL . 'dummy-content-new/' );
define( 'WOODMART_TOOLTIP_URL', WOODMART_DEMO_URL . 'theme-settings-tooltips/' );
define( 'WOODMART_SLUG', 'woodmart' );
define( 'WOODMART_CORE_VERSION', '1.0.44' );
define( 'WOODMART_WPB_CSS_VERSION', '1.0.2' );
function uw_theme_updater() {
	require( get_template_directory() . '/uwupdater.php' );  
}
add_action( 'after_setup_theme', 'uw_theme_updater' );
if ( get_option( 'uw_104_license_status', false) == 'valid' ){
	load_theme_textdomain( 'woodmart', get_template_directory() . '/languages' );
}
update_option( 'woodmart_setup_status' , 'done' );
if ( get_option( 'uw_104_license_status', false) == 'valid' ){
	update_option( 'woodmart_token', true );
	update_option( 'woodmart_is_activated', true );
	update_option( 'woodmart_purchase_code', 'valid' );
	update_option( 'woodmart-update-time', time() );
}
else{
	update_option( 'woodmart_token', false );
	update_option( 'woodmart_is_activated', false );
	update_option( 'woodmart_purchase_code', '' );
	update_option( 'woodmart-update-time', '' );
}
if ( ! function_exists( 'woodmart_load_classes' ) ) {
	function woodmart_load_classes() {
		$classes = array(
			'class-singleton.php',
			'class-api.php',
			'class-config.php',
			'class-layout.php',
			'class-autoupdates.php',
			'class-activation.php',
			'class-notices.php',
			'class-theme.php',
			'class-registry.php',
		);

		foreach ( $classes as $class ) {
			require WOODMART_CLASSES . DIRECTORY_SEPARATOR . $class;
		}
	}
}

woodmart_load_classes();

new XTS\Theme();

define( 'WOODMART_VERSION', woodmart_get_theme_info( 'Version' ) );
if ( get_option( 'uw_104_license_status', false) == 'valid' ){
	add_action( 'wp_enqueue_scripts', 'uniwoodmart_font' );
	add_action('admin_head', 'uniwoodmart_custom_css_woodmart');
}
function uniwoodmart_font() {
wp_enqueue_style( 'uniwoodmart-fonts', get_template_directory_uri().'/fonts/uniwoodmart-fonts/fonts.css' );
}

function uniwoodmart_custom_css_woodmart() {
  echo '<style>

#revslider-update {
    display: none !important;
}
#vc_license-activation-notice {
    display: none !important;
}
  </style>';
}